package paye.eoy.output.mapper.p35;

import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class ASPPRecoveredMapper extends AbstractRecoveredMapper {

    private static final String[] RULE_NAMES = new String[] { "ASPPRecoveredRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPP", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPP" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { AbstractRecoveredRuleOriginal.BAD_TOTAL, "7576", "ASPPRecovered.2" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MAXVALUE, "5012", "nonneg.amount" },
            { DocumentError.MINVALUE, "5012", "BR125.2.2" }, { DocumentError.MANDATORY, "6010", "generic.6010" },
            { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "ASPP recovered";

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
