package paye.eoy.output.mapper.p35;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class EmployeesOutOfUKMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] {
            "/IRenvelope/EndOfYearReturn/P35/CheckList/EmployeesOutOfUK",
            "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/EmployeesOutOfUK" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.VALUE, "5012", "BR104.1" } };

    private static final String LOCATOR = "Q4 - Employees out of UK";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
