/**
 * $Id: $
 */
package paye.eoy.output.mapper.p35;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractP14RequiredIfAnsweredYesRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Doug Clinton
 * 
 */
public class EmployeesPayToThirdPartyMapper extends AbstractPAYEErrorMapper {
    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.VALUE, "5012", "BR106.1" },
                { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_INVALID_ANS, "5012", "BR107.1" },
                { AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, "7260", "BR107.2" },
                { AbstractP14RequiredIfAnsweredYesRule.BLANK_INC_YES_ANS, "7260", "BR106.2" },
                { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_NO_ANS, "7260", "BR107.?" } };
    }

    /**
     * EmployessPayToThirdPartyRule deals with both the 'Included' attribute,
     * which forms part 1 of the question, and the element content, which is
     * part 2. The locator needs to be different depending on which subcode is
     * returned.
     */
    @Override
    protected String getLocator(final String subCode) {
        if (subCode.equals(DocumentError.VALUE)) {
            return "Q5 - Employees pay to third party";
        } else {
            return "Q5 part 2 - Employees pay to third party";
        }
    }

    public String[] getRuleNames() {
        return new String[] { "EmployeesPayToThirdPartyRule" };
    }

}
