/**
 * 
 */
package paye.eoy.output.mapper.p35;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.EmployerNameRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 * 
 */
public class EmployerNameMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { DocumentError.FORMAT, "5012", "BR8.1" },
                { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" },
                { EmployerNameRule.FIRST_CHAR_IS_SPACE, "5012", "BR8.1" } };
    }

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(EmployerNameRule.FIRST_CHAR_IS_SPACE, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return super.getTolerances(year, channel);
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Employer Name";
    }

    public String[] getRuleNames() {
        return new String[] { "/IRenvelope/EndOfYearReturn/P35/EmployerDetails/EmployerName",
                "/IRenvelope/EndOfYearReturn/P35Amended/EmployerDetails/EmployerName", "EmployerNameRule" };
    }

}
