package paye.eoy.output.mapper.p35;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class EndOfYearSummaryMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] {
            "/IRenvelope/EndOfYearReturn/P35/CheckList/CompletedEndOfYearSummary",
            "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/CompletedEndOfYearSummary", };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.VALUE, "5012", "BR101.1" },
            { DocumentError.MANDATORY, "6010", "BR101.mandatory" }, };

    private static final String LOCATOR = "Q1 - End of year summary";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
