package paye.eoy.output.mapper.p35;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class FreeOfTaxPaymentsMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] {
            "/IRenvelope/EndOfYearReturn/P35/CheckList/FreeOfTaxPayments",
            "/IRenvelope/EndOfYearReturn/P35Amended/CheckList/FreeOfTaxPayments" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.VALUE, "5012", "BR102.1" } };

    private static final String LOCATOR = "Q2 - Free of tax  payments";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
