package paye.eoy.output.mapper.p35;

import ericResponse.output.error.EricResponseErrors;
import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractIncentivePaymentRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class IncentivePaymentErrorMapperB extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{"IncentivePaymentRule"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{
            {AbstractIncentivePaymentRule.MAX_ALLOWED, "7475", "BR137.3"}, {DocumentError.FORMAT, "5012", "nonneg.amount"},
            {DocumentError.MANDATORY, "6010", "generic.6010"}, {DocumentError.BLANK, "5016", "generic.5016"},
            {DocumentError.MAXVALUE, EricResponseErrors.DO_NOT_MAP}, {DocumentError.MINVALUE, "5012", "BR137.2"},};

    private static final String LOCATOR = "Incentive Payment";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }

}
