package paye.eoy.output.mapper.p35;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.br1112.NICCompensationOnASPPRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class NICCompensationOnASPPMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "NICCompensationOnASPPRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/ASPPcompensation",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/ASPPcompensation" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { NICCompensationOnASPPRule.COMP_GT_ASPP, "7401", "NicCompOnASPP.3" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MAXVALUE, "5012", "nonneg.amount" },
            { DocumentError.MINVALUE, "5012", "BR125.3.2" }, { DocumentError.MANDATORY, "6010", "generic.6010" },
            { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "NIC compensation on ASPP";

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(NICCompensationOnASPPRule.COMP_GT_ASPP, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
