package paye.eoy.output.mapper.p35;

import paye.eoy.bizrules.p35.br1112.NICCompensationOnOSPPRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class NICCompensationOnOSPPMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "NICCompensationOnOSPPRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/OSPPcompensation",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/OSPPcompensation" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { NICCompensationOnOSPPRule.COMP_GT_OSPP, "7400", "BR125.3" }, { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR125.1.2" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "NIC compensation on OSPP";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
