package paye.eoy.output.mapper.p35;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractNICCompensationOnSMPRuleOriginal;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NICCompensationOnSMPMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{"NICCompensationOnSMPRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SMPcompensation",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SMPcompensation"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{
            {AbstractNICCompensationOnSMPRuleOriginal.GT_SMP_RECOVERED, "7360", "BR123.3"},
            {DocumentError.FORMAT, "5012", "nonneg.amount"}, {DocumentError.MAXVALUE, "5012", "nonneg.amount"},
            {DocumentError.MINVALUE, "5012", "BR123.2"}, {DocumentError.MANDATORY, "6010", "generic.6010"},
            {DocumentError.BLANK, "5016", "generic.5016"}};

    private static final String LOCATOR = "NIC compensation on SMP";

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractNICCompensationOnSMPRuleOriginal.GT_SMP_RECOVERED, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
