package paye.eoy.output.mapper.p35;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.NumberOfPartsRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

/**
 * @author Jay Mistry
 */
public final class NumberOfPartsMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        throw new UnsupportedOperationException("data varies by channel");
    }

    @Override
    protected String[][] getErrorMapData(final SubmissionChannel channel, TaxYear taxYear) {
        final String minValueMapping;
        if (channel == SubmissionChannel.Paper) {
            minValueMapping = "BR4.1.paper";
        } else {
            minValueMapping = "BR4.1";
        }
        return new String[][]{{DocumentError.MANDATORY, "7510", "BR4.mandatory"},
                {NumberOfPartsRule.NOT_REQUIRED, "7510", "BR4.2"}, {DocumentError.FORMAT, "5012", "BR4.1"},
                {DocumentError.MINVALUE, "5012", minValueMapping}, {DocumentError.MAXVALUE, "5012", "BR4.1"}};
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Number Of Parts";
    }

    public String[] getRuleNames() {
        return new String[]{"NumberOfPartsRule"};
    }

}
