package paye.eoy.output.mapper.p35;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractP38ADeclarationRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class P38ADeclarationMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "P38ADeclarationRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { AbstractP38ADeclarationRule.ARE_DUE, "7290", "BR111.2" },
            { AbstractP38ADeclarationRule.ARE_NOT_DUE, "7620", "BR111.3" }, { DocumentError.VALUE, "5012", "BR111.1" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractP38ADeclarationRule.ARE_DUE, Tolerance.DNA);
    }

    private static final String LOCATOR = "P38A Declaration";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
