package paye.eoy.output.mapper.p35;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.RevisedAmountNowPayableRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class RevisedAmountNowPayableMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "RevisedAmountNowPayableRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalAfterCISdeductions",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalAfterCISdeductions" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { RevisedAmountNowPayableRule.BAD_TOTAL, "7570", "BR139.2" }, { DocumentError.FORMAT, "5012", "amount" },
            { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(RevisedAmountNowPayableRule.BAD_TOTAL, Tolerance.DNA);
    }

    private static final String LOCATOR = "Revised amount now payable";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
