package paye.eoy.output.mapper.p35;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class SAPRecoveredMapper extends AbstractRecoveredMapper {

    private static final String[] RULE_NAMES = new String[]{"SAPRecoveredRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SAP", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SAP"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{
            {AbstractRecoveredRuleOriginal.BAD_TOTAL, "7410", "BR126.3"}, {DocumentError.FORMAT, "5012", "nonneg.amount"},
            {DocumentError.MAXVALUE, "5012", "nonneg.amount"}, {DocumentError.MINVALUE, "5012", "BR126.2"},
            {DocumentError.MANDATORY, "6010", "generic.6010"}, {DocumentError.BLANK, "5016", "generic.5016"}};

    private static final String LOCATOR = "SAP recovered";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
