package paye.eoy.output.mapper.p35;

import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import xmldoc.DocumentError;

public class SPPRecoveredMapper extends AbstractRecoveredMapper {

    private static final String[] RULE_NAMES = new String[] { "SPPRecoveredRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SPP", "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SPP" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { AbstractRecoveredRuleOriginal.BAD_TOTAL, "7575", "BR124.3" }, { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "nonneg.amount" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "SPP recovered";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
