package paye.eoy.output.mapper.p35;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractP14RequiredIfAnsweredYesRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class ServicePaymentsMapper extends AbstractPAYEErrorMapper {

    public static final ActiveTaxYear[] ACTIVE_TAX_YEARS = TaxYear.allActive();

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return ACTIVE_TAX_YEARS;
    }

    @Override
    protected String[][] getErrorMapData() {
        return new String[][] { { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_INVALID_ANS, "5012", "BR109.1" },
                { AbstractP14RequiredIfAnsweredYesRule.IS_INC_NO_P14, "7270", "BR109.2" },
                { AbstractP14RequiredIfAnsweredYesRule.BLANK_INC_YES_ANS, "7270", "BR109.(unknown-2)" },
                { AbstractP14RequiredIfAnsweredYesRule.HAS_INC_NO_ANS, "7270", "BR109.(unknown-3)" },
                { DocumentError.VALUE, "5012", "BR108.1" } };
    }

    @Override
    protected String getLocator(final String subCode) {
        if (DocumentError.VALUE.equals(subCode)) {
            return "Q6 - Service Payments";
        } else {
            return "Q6 part 2 - Service payments";
        }
    }

    public String[] getRuleNames() {
        return new String[] { "ServicePaymentsRule" };
    }

}
