package paye.eoy.output.mapper.p35;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.AbstractTotalAmountPayableRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class TotalAmountPayableMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalAmountPayableRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalPayable",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalPayable" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012", "amount" },
            { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
            { AbstractTotalAmountPayableRule.BAD_TOTAL, "7470", "BR135.2" } };

    private static final String LOCATOR = "Amount payable for the year";

    private static Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(AbstractTotalAmountPayableRule.BAD_TOTAL, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return Collections.emptyMap();
        }
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
