package paye.eoy.output.mapper.p35;

import paye.eoy.bizrules.p35.TotalNICRuleComplete;
import paye.eoy.bizrules.p35.TotalNICRuleP35Part;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class TotalNICErrorMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalNICRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/TotalNIC",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/TotalNIC" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { TotalNICRuleComplete.WRONG_TOTAL, "7320", "BR113.2" },
            { TotalNICRuleP35Part.SHOULD_BE_ZERO, "7320", "BR113.2" }, { DocumentError.FORMAT, "5012", "amount" },
            { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final String LOCATOR = "Total NIC";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
