package paye.eoy.output.mapper.p35;

import java.util.HashMap;
import java.util.Map;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.p35.TotalNICSTaxAndStLoanRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

public class TotalNICSTaxAndStLoanMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalNICSTaxAndStLoanRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/TotalNICsTaxAndStudentLoan" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { TotalNICSTaxAndStLoanRule.BAD_TOTAL, "7535", "BR120.2" }, { DocumentError.FORMAT, "5012", "amount" },
            { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" },
            { DocumentError.MANDATORY, "6010", "generic.6010" }, { DocumentError.BLANK, "5016", "generic.5016" } };

    private static final Map<String, Tolerance> TOLERANCES = new HashMap<String, Tolerance>();

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(TotalNICSTaxAndStLoanRule.BAD_TOTAL, Tolerance.DNA);
    }

    private static final String LOCATOR = "Total NIC/Tax and student loan";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        if (channel == SubmissionChannel.Paper) {
            return PAPER_TOLERANCES;
        } else {
            return TOLERANCES;
        }
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
