package paye.eoy.output.mapper.qs3;

import paye.channel.SubmissionChannel;
import paye.eoy.bizrules.qs3.TotalStudentLoanDeductionsRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class TotalStudentLoanDeductionsMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalStudentLoanDeductionsRule",
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/StudentLoan",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/StudentLoan" };


    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { TotalStudentLoanDeductionsRule.BAD_TOTAL, "7380", "BR119.3", },
            { TotalStudentLoanDeductionsRule.NON_WHOLE_AMOUNT, "5012", "BR119.4" },
            { DocumentError.FORMAT, "5012", "nonneg.amount" }, { DocumentError.MINVALUE, "5012", "BR119.2" },
            { DocumentError.MAXVALUE, "5012", "nonneg.amount" } };

    private static final String LOCATOR = "Total student loan deductions";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
            return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
