package paye.eoy.output.mapper.qs3;

import paye.eoy.bizrules.qs3.TotalStudentLoanRule;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class TotalStudentLoanMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "TotalStudentLoanRule" };

    private static final String[][] ERROR_MAP_DATA = new String[][] {
            { TotalStudentLoanRule.BAD_TOTAL, "7330", "BR56.2" }, { DocumentError.FORMAT, "5012", "amount" },
            { DocumentError.MINVALUE, "5012", "amount" }, { DocumentError.MAXVALUE, "5012", "amount" } };

    private static final String LOCATOR = "Total of student loan deductions";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
