package paye.eoy.output.mapper.summary;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class AdvanceReceivedToRefundMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[] { "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/TaxAdvance",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/TaxAdvance" };

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { DocumentError.MINVALUE, "5012", "BR115.2" }, { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, };

    private static final String LOCATOR = "Advance received from HMRC to refund tax";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
