package paye.eoy.output.mapper.summary;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class CISDeductionsMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/CISdeductions",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/CISdeductions"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{{DocumentError.FORMAT, "5012", "nonneg.amount"},
            {DocumentError.MINVALUE, "5012", "BR139.min"}, {DocumentError.MAXVALUE, "5012", "nonneg.amount"}};

    private static final String LOCATOR = "CIS deductions suffered";

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
