package paye.eoy.output.mapper.summary;

import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import xmldoc.DocumentError;

public class SSPSMPOSPPASPPandSAPFundingMapper extends AbstractPAYEErrorMapper {

    private static final String[][] ERROR_MAP_DATA = new String[][] { { DocumentError.FORMAT, "5012", "nonneg.amount" },
            { DocumentError.MINVALUE, "5012", "BR129.2" }, { DocumentError.MAXVALUE, "5012", "nonneg.amount" }, };

    private static final String[] RULE_NAMES_1112 = new String[] {
            "/IRenvelope/EndOfYearReturn/P35/Summary/NIC/SSPSMPOSPPASPPandSAPfunding",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/NIC/SSPSMPOSPPASPPandSAPfunding" };

    @Override
    public String[] getRuleNames() {
        return RULE_NAMES_1112;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData() {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return "Funding Received from HMRC to Pay SSP/SMP/OSPP/ASPP/SAP";
    }
}
