package paye.eoy.output.mapper.summary;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.multiyear.ActiveTaxYear;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import xmldoc.DocumentError;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SubContractorTaxMapper extends AbstractPAYEErrorMapper {

    private static final String[] RULE_NAMES = new String[]{
            // these are the paths for 0405 and 0506
            "/IRenvelope/EndOfYearReturn/P35/Summary/PAYE/SubcontractorTax",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/PAYE/SubcontractorTax",
            // it seems the paths changed to this for 0607
            "/IRenvelope/EndOfYearReturn/P35/Summary/CombinedAmounts/SubcontractorTax",
            "/IRenvelope/EndOfYearReturn/P35Amended/Summary/CombinedAmounts/SubcontractorTax"};

    private static final String[][] ERROR_MAP_DATA = new String[][]{{DocumentError.FORMAT, "5012", "nonneg.amount"},
            {DocumentError.MINVALUE, "5012", "BR116.2"}, {DocumentError.MAXVALUE, "5012", "nonneg.amount"},};

    private static final String LOCATOR = "Deductions made from subcontractors";

    private static final Map<String, Tolerance> PAPER_TOLERANCES = new HashMap<String, Tolerance>();

    static {
        PAPER_TOLERANCES.put(DocumentError.MINVALUE, Tolerance.DNA);
    }

    @Override
    protected Map<String, Tolerance> getTolerances(final TaxYear year, final SubmissionChannel channel) {
        return Collections.emptyMap();
    }

    public String[] getRuleNames() {
        return RULE_NAMES;
    }

    @Override
    protected ActiveTaxYear[] getActiveTaxYears() {
        return TaxYear.allActive();
    }

    @Override
    protected String[][] getErrorMapData(SubmissionChannel channel, TaxYear taxYear) {
        return ERROR_MAP_DATA;
    }

    @Override
    protected String getLocator(final String subCode) {
        return LOCATOR;
    }
}
