/**
 * $Id$
 */
package paye.eoy.types;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Douglas Clinton
 * @since Jan 9, 2006
 * 
 */
public class ReturnType {
    private static final String RETURN_TYPE_ORIGINAL_STRING = "original";

    private static final String RETURN_TYPE_AMENDED_STRING = "amended";

    public static final ReturnType ORIGINAL = new ReturnType(RETURN_TYPE_ORIGINAL_STRING);

    public static final ReturnType AMENDED = new ReturnType(RETURN_TYPE_AMENDED_STRING);

    private static Map<String, ReturnType> enumMap = new HashMap<String, ReturnType>();

    static {
        enumMap.put(ORIGINAL.toString(), ORIGINAL);
        enumMap.put(AMENDED.toString(), AMENDED);
    }

    private final String returnTypeString;

    private ReturnType(final String returnType) {
        this.returnTypeString = returnType;
    }

    @Override
    public String toString() {
        return returnTypeString;
    }

    // public boolean equals(Object other) is deliberately not implemented.
    // Because equality
    // between the enumeration values is just an identity comparison we can
    // leave it to the
    // default Object.equals() to handle.

    public static ReturnType fromString(final String value) throws IllegalArgumentException {
        final ReturnType result = enumMap.get(value);

        if (result == null) {
            throw new IllegalArgumentException("Unknown return type: '" + value + "'");
        }

        return result;
    }
}
