/**
 * $Id$
 */
package paye.eoy.types;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * An enumeration to represent the different submission types.
 * 
 * @author Douglas Clinton
 * @since Jan 9, 2006
 * 
 */
public final class SubmissionType implements Serializable {
    private static final String SUBMISSION_TYPE_COMPLETE_STRING = "complete";

    private static final String SUBMISSION_TYPE_P35PART_STRING = "P35Part";

    private static final String SUBMISSION_TYPE_P14PART_STRING = "P14Part";

    private static final String SUBMISSION_TYPE_CONSOLIDATED_STRING = "consolidated";

    private static final String SUBMISSION_TYPE_UNKNOWN = "Unknown";

    public static final SubmissionType COMPLETE = new SubmissionType(SUBMISSION_TYPE_COMPLETE_STRING);

    public static final SubmissionType P35PART = new SubmissionType(SUBMISSION_TYPE_P35PART_STRING);

    public static final SubmissionType P14PART = new SubmissionType(SUBMISSION_TYPE_P14PART_STRING);

    public static final SubmissionType CONSOLIDATED = new SubmissionType(SUBMISSION_TYPE_CONSOLIDATED_STRING);

    public static final SubmissionType UNKNOWN = new SubmissionType(SUBMISSION_TYPE_UNKNOWN);

    private static Map<String, SubmissionType> enumMap = new HashMap<String, SubmissionType>();

    static {
        enumMap.put(COMPLETE.toString(), COMPLETE);
        enumMap.put(P14PART.toString(), P14PART);
        enumMap.put(P35PART.toString(), P35PART);
        enumMap.put(CONSOLIDATED.toString(), CONSOLIDATED);
    }

    private final String submissionTypeString;

    private SubmissionType(final String submissionType) {
        this.submissionTypeString = submissionType;
    }

    @Override
    public String toString() {
        return submissionTypeString;
    }

    public boolean isPartSubmission() {
        return this == P35PART || this == P14PART;
    }

    // public boolean equals(Object other) is deliberately not implemented.
    // Because equality
    // between the enumeration values is just an identity comparison we can
    // leave it to the
    // default Object.equals() to handle.

    public static SubmissionType fromString(final String value) throws IllegalArgumentException {
        final SubmissionType result = enumMap.get(value);

        if (result == null) {
            throw new IllegalArgumentException("Unknown submission type: '" + value + "'");
        }

        return result;
    }

}
