package paye.eoy.validator;

import java.util.List;

import paye.channel.SubmissionChannel;
import paye.eoy.output.mapper.AbstractPAYEErrorMapper;
import paye.eoy.output.mapper.PAYETranslationContext;
import paye.multiyear.TaxYear;
import paye.tolerances.Tolerance;
import paye.tolerances.ToleranceSource;
import processingError.ProcessingError;
import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseErrorBean;
import ericResponse.output.translator.TranslationContext;
import ericResponse.output.translator.mapper.ErrorMapper;

public class PAYEEricResponseErrorBean extends EricResponseErrorBean implements PAYEEricResponseError {

    private ToleranceSource toleranceSource;

    public PAYEEricResponseErrorBean(final ERErrorDetail detail, final ProcessingError underlyingError,
            final TranslationContext translationContext, final ErrorMapper mapper) {
        super(detail, underlyingError, translationContext, mapper);
        if (mapper instanceof AbstractPAYEErrorMapper) {
            toleranceSource = ((AbstractPAYEErrorMapper) mapper).getToleranceSource();
        }
    }

    public Tolerance getTolerance() {
        if (toleranceSource == null || translationContext == null) {
            return Tolerance.TYPE_1;
        }
        final TaxYear year = ((PAYETranslationContext) translationContext).getTaxYear();
        final SubmissionChannel channel = ((PAYETranslationContext) translationContext).getChannel();
        return toleranceSource.getTolerance(year, channel, underlyingError.getSubCode());
    }

    public Object getValueInError() {
        return ((ProcessingError) getUnderlyingError()).getValueInError();
    }

    @Override
    public List<String> generateExtraDetailMessages() {
        final List<String> messages = super.generateExtraDetailMessages();
        messages.add(" tolerance: " + getTolerance() + ".");
        return messages;
    }

    @Override
    public int hashCode() {
        return (getCode() + getLocator() + getMessageText() + getTolerance().toString()).hashCode();
    }

    @Override
    public boolean equals(final Object other) {
        boolean result = false;
        if (other != null && other.getClass() == this.getClass() && super.equals(other)) {
            final PAYEEricResponseErrorBean that = (PAYEEricResponseErrorBean) other;
            result = toleranceSource.equals(that.toleranceSource);
        }
        return result;
    }

    @Override
    public String toString() {
        return "EricReponseError [BRCode =  '" + getBRCode() + "', mappingCode = '" + "', element = '" + "', locator = '"
                + getLocator() + "', code = " + getCode() + ", message text = '" + getMessageText() + ", tolerance = "
                + getTolerance().toString() + "]";
    }
}
