package paye.eoy.validator;

import hmrc.validator.HMRCValidationDelegate;
import hmrc.validator.HMRCValidationResultInterface;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import paye.eoy.output.mapper.header.IREnvelopeMapper;
import processingError.ProcessingError;

import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidationResultInterface;

import ericResponse.output.ApplicationElementGenerator;

public class PAYEValidationDelegate extends HMRCValidationDelegate {

    public PAYEValidationDelegate(final PAYEValidationParams params, final Writer output) {
        super(params.getResponseParams(), output);
    }

    @Override
    public ValidationResultInterface createResult(final List<ProcessingError> processingErrors, final ValidationParams params) {
        addErrorMapper(new IREnvelopeMapper());
        return super.createResult(processingErrors, params);
    }

    @Override
    protected HMRCValidationResultInterface createHMRCResult() {
        return new PAYEValidationResultBean();
    }

    @Override
    protected List<ApplicationElementGenerator> makeApplicationElementGenerators(
            final HMRCValidationResultInterface validationResult, final ValidationParams params) {
        final PAYEValidationParams payeParams = (PAYEValidationParams) params;
        final PAYEValidationResult payeResult = (PAYEValidationResult) validationResult;

        final List<ApplicationElementGenerator> result = new ArrayList<ApplicationElementGenerator>();

        if (payeParams.getInjectMISResultIntoResponse()) {
            result.add(new PAYEValidationResultGenerator(payeResult));
        }

        return result;
    }
}
