package paye.eoy.validator;

import hmrc.validator.HMRCValidationResultBean;
import paye.channel.SubmissionChannel;
import paye.eoy.types.SubmissionType;
import paye.multiyear.TaxYear;
import ericResponse.output.PAYESubmissionDetails;

/**
 * This class provides access to the results of validating a PAYE submission.
 */
public class PAYEValidationResultBean extends HMRCValidationResultBean implements PAYEValidationResult {

    private static final long serialVersionUID = 1L;

    private int p14Count = 0;

    private SubmissionType submissionType = SubmissionType.UNKNOWN;

    private transient PAYESubmissionDetails payeSubmissionDetails;

    private transient TaxYear taxYear = null;

    private transient SubmissionChannel channel;

    public int getP14Count() {
        return p14Count;
    }

    public void setP14Count(final int count) {
        p14Count = count;
    }

    public SubmissionType getSubmissionType() {
        return submissionType;
    }

    public void setSubmissionType(final SubmissionType submissionType) {
        this.submissionType = submissionType;
    }

    public PAYESubmissionDetails getPayeSubmissionDetails() {
        return payeSubmissionDetails;
    }

    public void setPayeSubmissionDetails(final PAYESubmissionDetails payeSubmissionDetails) {
        this.payeSubmissionDetails = payeSubmissionDetails;
    }

    public TaxYear getTaxYear() {
        return taxYear;
    }

    public void setTaxYear(final TaxYear taxYear) {
        this.taxYear = taxYear;
    }

    public SubmissionChannel getChannel() {
        return channel;
    }

    public void setChannel(final SubmissionChannel channel) {
        this.channel = channel;
    }

    @Override
    public String toString() {
        return "ValidationResult [qs2Result='" + getQS2Result() + ", QS3Result='" + getQS3Result() + "', processing time="
                + getProcessingTime() + ", p14Count = " + p14Count + "]";
    }
}
