/**
 * 
 */
package paye.eoy.validator;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

import ericResponse.output.ApplicationElementGenerator;
import ericResponse.output.EricResponseParams;

/**
 * @author doug
 * 
 */
public class PAYEValidationResultGenerator implements ApplicationElementGenerator {
    protected static final String PREFIX_VALIDATION_RESULT = "vr";

    private static final String URI_VALIDATION_RESULT = "http://www.hmrc.gov.uk/PAYE/EOY/validationResult";

    private static final Namespace NS_VALIDATION_RESULT = Namespace.getNamespace(URI_VALIDATION_RESULT);

    private final PAYEValidationResult result;

    public PAYEValidationResultGenerator(final PAYEValidationResult validationResult) {
        this.result = validationResult;

    }

    public List<Element> generate(EricResponseParams params) {
        final List<Element> elements = new ArrayList<Element>();

        final Element root = element("PAYEValidationResult");
        elements.add(root);

        {
            root.addContent(numberElement("P14Count", result.getP14Count()));
        }

        {
            final Element submissionResultElement = element("submissionResult");
            submissionResultElement.addContent(stringElement("submissionType", result.getSubmissionType()));
            root.addContent(submissionResultElement);
        }

        {
            final Element qs2ResultElement = element("QS2Result");
            final Element validationStatusElement = element("validationStatus");
            validationStatusElement.addContent(stringElement("statusString", result.getQS2Result().getValidationStatus()));
            qs2ResultElement.addContent(validationStatusElement);

            if (result.getQS2Result().getErrorCount() > 0) {
                validationStatusElement.addContent(numberElement("errorCount", result.getQS2Result().getErrorCount()));
            }
            root.addContent(qs2ResultElement);
        }

        {
            final Element qs3ResultElement = element("QS3Result");
            final Element validationStatusElement = element("validationStatus");
            validationStatusElement.addContent(stringElement("statusString", result.getQS3Result().getValidationStatus()));
            qs3ResultElement.addContent(validationStatusElement);

            if (result.getQS3Result().getErrorCount() > 0) {
                validationStatusElement.addContent(numberElement("errorCount", result.getQS3Result().getErrorCount()));

                if (params.getOutputQS3Discrepancy()) {
                    qs3ResultElement.addContent(stringElement("totalDiscrepancy", result.getQS3MonetaryDiscrepancy()));
                }
            }
            root.addContent(qs3ResultElement);
        }

        return elements;
    }

    protected Element booleanElement(final String name, final boolean value) {
        final Element tolAtQS2 = element(name);
        tolAtQS2.setContent(new Text(Boolean.toString(value)));

        return tolAtQS2;
    }

    private Element stringElement(final String name, final Object value) {
        final Element tolAtQS2 = element(name);
        tolAtQS2.setContent(new Text(value.toString()));

        return tolAtQS2;
    }

    private Element numberElement(final String name, final int value) {
        final Element tolAtQS2 = element(name);
        tolAtQS2.setContent(new Text(Integer.toString(value)));

        return tolAtQS2;
    }

    private Element element(final String name) {
        return new Element(name, NS_VALIDATION_RESULT);
    }

}
