/**
 * 
 */
package paye.eoy.validator;

import java.io.IOException;
import java.io.InputStream;

import org.xml.sax.InputSource;

import processingError.ProcessingErrorCollector;
import xmldoc.sax.DocumentHandler;
import chris.header.ChRISEnvelopeFilter;

import com.gsl.docValidator.DocumentValidatorServices;

import eric.header.ERICEnvelopeFilter;
import ericResponse.output.EricResponsePostValidationDelegate;
import govtalk.header.GovTalkEnvelopeFilter;

class PAYEValidatorServices extends DocumentValidatorServices {

    private final EricResponsePostValidationDelegate delegate;

    private final PAYEValidationParams payeValidationParams;

    PAYEValidatorServices(final PAYEValidationParams params, final EricResponsePostValidationDelegate delegate) {
        super(params);
        this.payeValidationParams = params;
        this.delegate = delegate;
    }

    @Override
    protected InputSource createInputSource(final InputStream input) throws IOException {
        throw new IllegalArgumentException("PAYE Validator does not support input streams since there is not decompression support");
    }

    @Override
    protected DocumentHandler createDocumentHandler() {
        final DocumentHandler documentHandler = super.createDocumentHandler();

        if (this.payeValidationParams.isSuppressGatewayEnvelopeErrors()) {
            documentHandler.addDocumentErrorFilter(new GovTalkEnvelopeFilter());
            documentHandler.addDocumentErrorFilter(new ERICEnvelopeFilter());
            documentHandler.addDocumentErrorFilter(new ChRISEnvelopeFilter());
        }

        return documentHandler;
    }

    @Override
    protected ProcessingErrorCollector createErrorCollector() {
        ProcessingErrorCollector collector = super.createErrorCollector();

        if (this.payeValidationParams.isToleranceCheckRequired()) {
            collector = new DNAFilteringErrorCollector(collector, delegate);
        }
        return collector;
    }
}