package paye.eoy.validator;

import hmrc.validator.result.QSResult;
import hmrc.validator.result.ValidationStatus;

public class SubmissionStatusFactory {

    // THRUTH TABLE :
    // ___________\QS2 | _Passed_ | _Failed_ | Tolerated
    // ________QS3_____+--------------------------------
    // _____Passed_____| ACCEPTED | REJECTED | ACCEPTED
    // _____Failed_____| REJECTED | REJECTED | REJECTED
    // __Tolerated_____| ACCEPTED | REJECTED | ACCEPTED
    // __Not valid_____| ACCEPTED | REJECTED | ACCEPTED

    private final static ValidationStatus[] COLUMN_HEADINGS = { ValidationStatus.PASSED, ValidationStatus.FAILED,
            ValidationStatus.TOLERATED };

    private final static ValidationStatus[] ROW_HEADINGS = { ValidationStatus.PASSED, ValidationStatus.FAILED,
            ValidationStatus.TOLERATED, ValidationStatus.NOT_VALIDATED };

    private final static SubmissionStatus[][] TRUTH_TABLE = new SubmissionStatus[][] {
            { SubmissionStatus.ACCEPTED, SubmissionStatus.REJECTED, SubmissionStatus.ACCEPTED },
            { SubmissionStatus.REJECTED, SubmissionStatus.REJECTED, SubmissionStatus.REJECTED },
            { SubmissionStatus.ACCEPTED, SubmissionStatus.REJECTED, SubmissionStatus.ACCEPTED },
            { SubmissionStatus.ACCEPTED, SubmissionStatus.REJECTED, SubmissionStatus.ACCEPTED } };

    /**
     * @returns the submission status based upon the qs2 and qs3 results.
     */
    public static SubmissionStatus getInstance(final QSResult qs2Result, final QSResult qs3Result) {
        final ValidationStatus qs2ValidationStatus = qs2Result.getValidationStatus();
        final ValidationStatus qs3ValidationStatus = qs3Result.getValidationStatus();

        // Column heading

        int columnHeadingIndex = -1;
        {
            for (int i = 0; i < COLUMN_HEADINGS.length; i++) {
                if (qs2ValidationStatus == COLUMN_HEADINGS[i]) {
                    columnHeadingIndex = i;
                    break;
                }
            }

            if (columnHeadingIndex == -1) {
                throw new AssertionError("Unknown QS2 Validation Status");
            }
        }

        // row heading

        int rowHeadingIndex = -1;
        for (int i = 0; i < ROW_HEADINGS.length; i++) {
            if (qs3ValidationStatus == ROW_HEADINGS[i]) {
                rowHeadingIndex = i;
                break;
            }
        }

        if (rowHeadingIndex == -1) {
            throw new AssertionError("Unknown QS3 Validation Status");
        }

        return TRUTH_TABLE[rowHeadingIndex][columnHeadingIndex];
    }
}
