package paye.eoy.validator;

import java.util.Iterator;
import java.util.List;

import paye.tolerances.Tolerance;
import ericResponse.output.EricErrorFilter;
import ericResponse.output.error.EricResponseError;

/**
 * An Eric error filter that filters out any errors with a Tolerance of DNA.
 */
public class ToleranceDNAFilter implements EricErrorFilter {

    public List<EricResponseError> filterErrors(final List<EricResponseError> ericErrors) {
        for (final Iterator<EricResponseError> iter = ericErrors.iterator(); iter.hasNext();) {
            final EricResponseError error = iter.next();
            if (error instanceof PAYEEricResponseError) {
                final PAYEEricResponseError payeError = (PAYEEricResponseError) error;
                if (payeError.getTolerance() == Tolerance.DNA) {
                    // remove errors in-place
                    iter.remove();
                }
            }
        }
        return ericErrors;
    }
}
