package paye.multiyear;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author doug
 * @since May 24, 2005
 */
public class DateHelper {
    private static final String DATE_FORMAT_STRING = "yyyy-MM-dd";

    public static final Date april5th2003;
    public static final Date april6th2003;
    public static final Date april5th2004;
    public static final Date april6th2004;
    public static final Date april5th2005;
    public static final Date april6th2005;
    public static final Date april5th2006;
    public static final Date april6th2006;
    public static final Date april5th2007;
    public static final Date april6th2007;
    public static final Date april5th2008;
    public static final Date april6th2008;
    public static final Date april5th2009;
    public static final Date april6th2009;
    public static final Date april5th2010;
    public static final Date april6th2010;
    public static final Date april5th2011;
    public static final Date april6th2011;
    public static final Date april5th2012;
    public static final Date april6th2012;
    public static final Date april5th2013;
    public static final Date april6th2013;
    public static final Date april5th2014;
    public static final Date april6th2014;
    public static final Date april5th2015;
    public static final Date april6th2015;
    public static final Date april5th2016;
    public static final Date april6th2016;
    public static final Date april5th2017;
    public static final Date april6th2017;
    public static final Date april5th2018;
    public static final Date april6th2018;
    public static final Date april5th2019;
    public static final Date april6th2019;
    public static final Date april5th2020;
    public static final Date april6th2020;
    public static final Date april5th2021;
    public static final Date april6th2021;
    public static final Date april5th2022;
    public static final Date april6th2022;
    public static final Date april5th2023;
    public static final Date april6th2023;
    public static final Date april5th2024;
    public static final Date april6th2024;

    static {
        final DateFormat df = createDateFormat();
        df.setLenient(false);
        april5th2003 = makeDate(2003, Calendar.APRIL, 5);
        april6th2003 = makeDate(2003, Calendar.APRIL, 6);
        april5th2004 = makeDate(2004, Calendar.APRIL, 5);
        april6th2004 = makeDate(2004, Calendar.APRIL, 6);
        april5th2005 = makeDate(2005, Calendar.APRIL, 5);
        april5th2006 = makeDate(2006, Calendar.APRIL, 5);
        april6th2005 = makeDate(2005, Calendar.APRIL, 6);
        april6th2006 = makeDate(2006, Calendar.APRIL, 6);
        april5th2007 = makeDate(2007, Calendar.APRIL, 5);
        april6th2007 = makeDate(2007, Calendar.APRIL, 6);
        april5th2008 = makeDate(2008, Calendar.APRIL, 5);
        april6th2008 = makeDate(2008, Calendar.APRIL, 6);
        april5th2009 = makeDate(2009, Calendar.APRIL, 5);
        april6th2009 = makeDate(2009, Calendar.APRIL, 6);
        april5th2010 = makeDate(2010, Calendar.APRIL, 5);
        april6th2010 = makeDate(2010, Calendar.APRIL, 6);
        april5th2011 = makeDate(2011, Calendar.APRIL, 5);
        april6th2011 = makeDate(2011, Calendar.APRIL, 6);
        april5th2012 = makeDate(2012, Calendar.APRIL, 5);
        april6th2012 = makeDate(2012, Calendar.APRIL, 6);
        april5th2013 = makeDate(2013, Calendar.APRIL, 5);
        april6th2013 = makeDate(2013, Calendar.APRIL, 6);
        april5th2014 = makeDate(2014, Calendar.APRIL, 5);
        april6th2014 = makeDate(2014, Calendar.APRIL, 6);
        april5th2015 = makeDate(2015, Calendar.APRIL, 5);
        april6th2015 = makeDate(2015, Calendar.APRIL, 6);
        april5th2016 = makeDate(2016, Calendar.APRIL, 5);
        april6th2016 = makeDate(2016, Calendar.APRIL, 6);
        april5th2017 = makeDate(2017, Calendar.APRIL, 5);
        april6th2017 = makeDate(2017, Calendar.APRIL, 6);
        april5th2018 = makeDate(2018, Calendar.APRIL, 5);
        april6th2018 = makeDate(2018, Calendar.APRIL, 6);
        april5th2019 = makeDate(2019, Calendar.APRIL, 5);
        april6th2019 = makeDate(2019, Calendar.APRIL, 6);
        april5th2020 = makeDate(2020, Calendar.APRIL, 5);
        april6th2020 = makeDate(2020, Calendar.APRIL, 6);
        april5th2021 = makeDate(2021, Calendar.APRIL, 5);
        april6th2021 = makeDate(2021, Calendar.APRIL, 6);
        april5th2022 = makeDate(2022, Calendar.APRIL, 5);
        april6th2022 = makeDate(2022, Calendar.APRIL, 6);
        april5th2023 = makeDate(2023, Calendar.APRIL, 5);
        april6th2023 = makeDate(2023, Calendar.APRIL, 6);
        april5th2024 = makeDate(2024, Calendar.APRIL, 5);
        april6th2024 = makeDate(2024, Calendar.APRIL, 6);
    }

    public static Date makeDate(final int year, final int month, final int day) {
        final Calendar cal = new GregorianCalendar(year, month, day);
        return cal.getTime();
    }

    public static Date today() {
        final Calendar cal = new GregorianCalendar();
        final Calendar cal2 = new GregorianCalendar(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH),
                cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);

        return cal2.getTime();
    }

    /**
     * This will parse a date in the format "yyyy-MM-dd". Note that because the
     * java SimpleDateFormat.parse is quite flexible about the formats that will
     * be accepted you should not rely on this to report formatting errors. The
     * schema is often a lot more strict on format violations and should be
     * relied on instead.
     */
    public static Date parseDate(final String dateString) throws ParseException {
        Date date = null;
        final DateFormat df = createDateFormat();
        date = df.parse(dateString);

        return date;
    }

    /**
     * Returns a date in the format "yyyy-MM-dd". Note that because the java
     * SimpleDateFormat.parse is quite flexible about the formats that will be
     * accepted you should not rely on this to report formatting errors. The
     * schema is often a lot more strict on format violations and should be
     * relied on instead.
     */
    public static DateFormat createDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT_STRING);
    }
}