/*
 * Created on 12-Dec-2005
 *
 * $Id: ToleranceResultBean.java,v 1.2 2006/02/28 16:13:00 dec Exp $
 */
package paye.tolerances;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * $Id: ToleranceResultBean.java,v 1.2 2006/02/28 16:13:00 dec Exp $
 */
public class ToleranceResultBean implements Serializable, ToleranceResult {

    public static final ToleranceResult NULL = new ToleranceResultBean();

    private boolean isToleratedAtQS2 = true;

    private boolean isToleratedAtQS3 = true;

    private BigDecimal totalDiscrepancies = new BigDecimal(0.0);

    public void failedQS2Tolerance() {
        this.isToleratedAtQS2 = false;
    }

    public void failedQS3Tolerance() {
        this.isToleratedAtQS3 = false;
    }

    /**
     * adds the discrepancy, to get the total of all the discrepancy use
     * getTotalDiscrepancy
     * 
     * @see getTotalDiscrepancy()
     */
    public double addDiscrepancy(final BigDecimal discrepancies) {
        totalDiscrepancies = totalDiscrepancies.add(discrepancies);
        return getTotalDiscrepancy();
    }

    /**
     * returns true if the request passes with tollerances
     */
    public boolean isToleratedAtQS2() {
        return isToleratedAtQS2;
    }

    /**
     * @return gets the total of all the discrepancy
     */
    public double getTotalDiscrepancy() {
        return totalDiscrepancies.doubleValue();
    }

    public boolean isToleratedAtQS3() {
        return isToleratedAtQS3;
    }

}