/*
 * Created on 21-Dec-2005
 *
 * $Id: ToleranceParameters.java,v 1.2 2006/01/26 16:57:27 raustin Exp $
 */
package paye.tolerances.parameters;

/**
 * $Id: ToleranceParameters.java,v 1.2 2006/01/26 16:57:27 raustin Exp $
 */
public interface ToleranceParameters {

    /**
     * returns the max number of type two errors that can be tolerated by the
     * inland revenue.
     */
    int getMaxNumberOfTypeTwoDiscrepancies();

    /**
     * returns a percentage, for example 1% (as 1.0), to represent the tolerance
     */
    double getTotalDiscrepancyPercentageOfTotalPayableTolerance();

    /**
     * returns a threshold amount, any monetary discrepancy below this amount
     * will always be tolerated
     */
    double getTotalDescrepancyThreshold();

    /**
     * return the maximum monetary discrepancies allowed
     */
    double getTotalDiscrepancyTolerance();

    /**
     * returns a percentage, for example 25% ( as 25.0 ), to represent the
     * tolerance of type 2 errors related to the p14 count.
     */
    double getTypeTwoDiscrepancyTolerancePercentageOfP14Count();
}
