/*
 * Created on 21-Dec-2005
 * 
 * $Id: ToleranceParametersFactory.java,v 1.5 2006/03/08 16:16:23 raustin Exp $
 */
package paye.tolerances.parameters;

import paye.multiyear.TaxYear;

/**
 * 
 * 
 * $Id: ToleranceParametersFactory.java,v 1.5 2006/03/08 16:16:23 raustin Exp $
 */
public class ToleranceParametersFactory {

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0405;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0506;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0607;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0708;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0809;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_0910;

    private static final ToleranceParameters TOLERANCE_PARAMETERS_1011;

    public static final ToleranceParameters NO_TOLERANCES_FOR_TAX_YEAR = new ToleranceParametersImpl(0, 0, 0, 0, 0);

    public static final ToleranceParameters ZERO_TOLERANCES = new ToleranceParametersImpl(0, 0, 0, 0, 0);

    static {
        TOLERANCE_PARAMETERS_0405 = new ToleranceParametersImpl(200, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_0506 = new ToleranceParametersImpl(200, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_0607 = new ToleranceParametersImpl(200, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_0708 = new ToleranceParametersImpl(200, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_0809 = new ToleranceParametersImpl(150, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_0910 = new ToleranceParametersImpl(150, 1.0, 25.0, 500.0, 25.0);
        TOLERANCE_PARAMETERS_1011 = new ToleranceParametersImpl(150, 1.0, 25.0, 500.0, 25.0);
    }

    /**
     * @return the tolerances parameters for the given year. If tolerances are
     *         not supported for the supplied year then this will return the
     *         constant NO_TOLERANCES_FOR_TAX_YEAR
     * 
     * @since 21-Dec-2005
     */
    public static final ToleranceParameters getInstance(final TaxYear taxYear) {
        final ToleranceParameters result;
        if (taxYear == TaxYear.TAX_YEAR_0405) {
            result = TOLERANCE_PARAMETERS_0405;
        } else if (taxYear == TaxYear.TAX_YEAR_0506) {
            result = TOLERANCE_PARAMETERS_0506;
        } else if (taxYear == TaxYear.TAX_YEAR_0607) {
            result = TOLERANCE_PARAMETERS_0607;
        } else if (taxYear == TaxYear.TAX_YEAR_0708) {
            result = TOLERANCE_PARAMETERS_0708;
        } else if (taxYear == TaxYear.TAX_YEAR_0809) {
            result = TOLERANCE_PARAMETERS_0809;
        } else if (taxYear == TaxYear.TAX_YEAR_0910) {
            result = TOLERANCE_PARAMETERS_0910;
        } else if (taxYear == TaxYear.TAX_YEAR_1011) {
            result = TOLERANCE_PARAMETERS_1011;
        } else {
            result = NO_TOLERANCES_FOR_TAX_YEAR;
        }
        return result;
    }
}
