package paye.tolerances.parameters;

/**
 * Instances of this class hold the various tolerance thresholds. An instance is
 * created for each supported tax year, since the thresholds can change each
 * year.
 * 
 * @see ToleranceParametersFactory
 */
class ToleranceParametersImpl implements ToleranceParameters {

    private final int maxNumberOfTypeTwoDiscrepancies; // 200/150

    private final double totalDiscrepancyTolerance; // 500

    private final double totalDiscrepancyPercentageOfTotalPayableTolerance; // 1%

    private final double totalDescrepancyThreshold; // 25

    private final double typeTwoDiscrepancyTolerancePercentageOfP14Count; // 25%

    public ToleranceParametersImpl(final int maxNumberOfTypeTwoDiscrepancies,
            final double totalDiscrepancyPercentageOfTotalPayableTolerance, final double totalDescrepancyThreshold,
            final double totalDiscrepancyTolerance, final double typeTwoDiscrepancyTolerancePercentageOfP14Count) {
        this.maxNumberOfTypeTwoDiscrepancies = maxNumberOfTypeTwoDiscrepancies;
        this.totalDiscrepancyPercentageOfTotalPayableTolerance = totalDiscrepancyPercentageOfTotalPayableTolerance;
        this.totalDescrepancyThreshold = totalDescrepancyThreshold;
        this.totalDiscrepancyTolerance = totalDiscrepancyTolerance;
        this.typeTwoDiscrepancyTolerancePercentageOfP14Count = typeTwoDiscrepancyTolerancePercentageOfP14Count;
    }

    public int getMaxNumberOfTypeTwoDiscrepancies() {
        return maxNumberOfTypeTwoDiscrepancies;
    }

    public double getTotalDiscrepancyPercentageOfTotalPayableTolerance() {
        return totalDiscrepancyPercentageOfTotalPayableTolerance;
    }

    public double getTotalDescrepancyThreshold() {
        return totalDescrepancyThreshold;
    }

    public double getTotalDiscrepancyTolerance() {
        return totalDiscrepancyTolerance;
    }

    public double getTypeTwoDiscrepancyTolerancePercentageOfP14Count() {
        return typeTwoDiscrepancyTolerancePercentageOfP14Count;
    }
}
