/*
 * Created on 12-Dec-2005
 *
 * $Id: ToleranceValidatorFactory.java,v 1.1 2006/01/20 14:06:06 dec Exp $
 */
package paye.tolerances.validator;

import java.util.List;

import paye.multiyear.TaxYear;
import paye.tolerances.parameters.ToleranceParameters;
import paye.tolerances.parameters.ToleranceParametersFactory;
import ericResponse.output.error.EricResponseError;

/**
 * $Id: ToleranceValidatorFactory.java,v 1.1 2006/01/20 14:06:06 dec Exp $
 */
public class ToleranceValidatorFactory {
    public static final ToleranceValidator newInstance(final TaxYear taxYear, final List<EricResponseError> ericResponseErrors2,
            final int p14Count, final double totalPayable) {
        final ToleranceParameters toleranceParameters = ToleranceParametersFactory.getInstance(taxYear);
        return new ToleranceValidatorImpl(toleranceParameters, ericResponseErrors2, p14Count, totalPayable);
    }

    public static final ToleranceValidator instanceWithZeroToleranceThresholds(final TaxYear taxYear,
            final List<EricResponseError> ericResponseErrors2, final int p14Count, final double totalPayable) {
        return new ToleranceValidatorImpl(ToleranceParametersFactory.ZERO_TOLERANCES, ericResponseErrors2, p14Count, totalPayable);
    }
}
