package processingError;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;

public abstract class AbstractProcessingError implements ProcessingError {

    private static final Location NULL_LOCATION = new SimpleLocation(0, 0, "", null);

    private Location location = NULL_LOCATION;

    private ErrorProcessor errorProcessor;

    private ProcessingError chainedError = null;

    private final List<Object> applicationData = new ArrayList<Object>();

    public AbstractProcessingError(final Location location) {
        this.location = location;
    }

    public AbstractProcessingError(final Location location, final Attributes attributes) {
        this(location);
    }

    @Override
    public String toString() {
        String lookupString = "";

        if (getLocation() != null) {
            lookupString = ":" + getLocation().getLineNumber() + ":" + getLocation().getColumnNumber() + ":" + buildTagName() + ":";
        }

        lookupString += getDescription();
        String result = lookupString;

        if (getValueInError() != null) {
            result += ":[" + getValueInError() + "]";
        }
        return result;
    }

    protected String buildTagName() {
        String result = getLocation().getTagName();
        final Attributes attributes = getLocation().getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            result += "[";
            for (int i = 0; i < attributes.getLength(); i++) {
                if (i > 0)
                    result += ",";
                result += attributes.getQName(i) + "='";
                result += attributes.getValue(i) + "'";
            }
            result += "]";
        }
        return result;
    }

    public Location getLocation() {
        return location;
    }

    public List<Object> getApplicationData() {
        return applicationData;
    }

    public void addApplicationData(final Object datum) {
        applicationData.add(datum);
    }

    public String getDescription() {
        return getRuleName() + "." + getSubCode();
    }

    public void setLocation(final Location location) {
        this.location = location;
    }

    public ErrorProcessor getErrorProcessor() {
        return errorProcessor;
    }

    public void setErrorProcessor(final ErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
    }

    public ProcessingError getChainedError() {
        return chainedError;
    }

    public void setChainedError(final ProcessingError chainedError) {
        this.chainedError = chainedError;
    }

    public String getErrorCode() {
        return null;
    }

    public String getMessage() {
        return null;
    }
}
