/**
 * $Id: NullErrorCollector.java,v 1.1 2006/08/10 15:19:13 dec Exp $
 */
package processingError;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * Represents a singleton.
 * 
 * @author Doug Clinton
 * @since 22-Feb-2006
 */
public class NullErrorCollector implements ProcessingErrorCollector {

    /**
     * Holds singleton instance
     */
    private static NullErrorCollector instance;

    public void addError(final ProcessingError error) {
        // do nothing
    }

    public void addErrors(final Collection<? extends ProcessingError> errors) {
        // do nothing

    }

    public List<ProcessingError> getErrors() {
        return Collections.emptyList();
    }

    public void clearErrors() {
        // do nothing
    }

    public void ignoreFurtherErrors() {
        // do nothing
    }

    /**
     * prevents instantiation
     */
    private NullErrorCollector() {
        // prevent creation
    }

    /**
     * Returns the singleton instance.
     * 
     * @return the singleton instance
     */
    static public NullErrorCollector instance() {
        if (instance == null) {
            instance = new NullErrorCollector();
        }
        return instance;
    }

    public Object getErrorExtraInfo() {
        return null;
    }

    /**
     * Null implementation ignores the parameter.
     */
    public void setErrorExtraInfo(final Object errorExtraInfo) {
        // do nothing
    }

    public void setMaxErrors(final int maxErrors) {
        throw new UnsupportedOperationException("implement me!");
    }

    public void dumpErrorsNotOfType(final Class<? extends ProcessingError> clazz) {
        throw new UnsupportedOperationException("implement me!");
    }
}
