package processingError;

import java.util.List;

/**
 * Describes an object which can collect a set of processing errors.
 * 
 * @author Douglas Clinton
 * @since Jan 26, 2006
 * 
 */
public interface ProcessingErrorCollector {
    void addError(ProcessingError error) throws ErrorLimitExceeded;

    void setErrorExtraInfo(Object extraInfo);

    Object getErrorExtraInfo();

    List<ProcessingError> getErrors();

    /**
     * Flush out all the errors currently held by the ProcessingErrorCollector.
     * 
     */
    void clearErrors();

    /**
     * Set the maximum number of errors that this collector will accept. Trying
     * to call addError() after this limit has been reached will result in an
     * ErrorLimitExceded error being thrown.
     */
    void setMaxErrors(int maxErrors);

    /**
     * Remove any collected errors which do not have this type.
     */
    void dumpErrorsNotOfType(Class<? extends ProcessingError> clazz);
}