/*
 * Created on May 25, 2005
 * 
 * $Id: SimpleErrorCollector.java,v 1.1 2006/08/10 15:19:13 dec Exp $
 */
package processingError;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * 
 * @author doug
 * @since May 25, 2005
 */
public class SimpleErrorCollector implements ProcessingErrorCollector {
    private final List<ProcessingError> errors = new ArrayList<ProcessingError>();

    private Object errorExtraInfo = null;

    private int maxErrors = 100000;

    public void addError(final ProcessingError error) {
        if (maxErrors > 0 && errors.size() >= maxErrors) {
            /*
             * XXX This is really just an optimization to cause processing to be
             * stopped if the maximum error count is reached, since it can take
             * a long time to process a large submission with a huge number of
             * errors. Also, there is the potential for running out of memory in
             * extreme cases. However, it is causing some bad interaction with
             * the requirements to report only schema errors or business rule
             * errors, not both and the requirement to filter out GovTalk
             * envelope errors.
             */
            throw new ErrorLimitExceeded(maxErrors, error);
        } else {
            errors.add(error);
        }
    }

    public void clearErrors() {
        errors.clear();
    }

    public List<ProcessingError> getErrors() {
        return errors;
    }

    public Object getErrorExtraInfo() {
        return errorExtraInfo;
    }

    public void setErrorExtraInfo(final Object errorExtraInfo) {
        this.errorExtraInfo = errorExtraInfo;
    }

    public int getMaxErrors() {
        return maxErrors;
    }

    public void setMaxErrors(final int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public void dumpErrorsNotOfType(final Class<? extends ProcessingError> clazz) {
        for (final Iterator<ProcessingError> iter = errors.iterator(); iter.hasNext();) {
            final ProcessingError error = iter.next();
            if (!clazz.isAssignableFrom(error.getClass())) {
                iter.remove();
            }
        }
    }
}