/**
 * $Id: SimpleLocation.java,v 1.1 2006/08/10 15:19:13 dec Exp $
 */
package processingError;

import org.xml.sax.Attributes;

/**
 * @author Douglas Clinton
 * @since Mar 27, 2006
 * 
 */
public class SimpleLocation implements Location {
    private final int columnNumber;

    private final int lineNumber;

    private final String tagName;

    private final Attributes attributes;

    public Attributes getAttributes() {
        return attributes;
    }

    public int getColumnNumber() {
        return columnNumber;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public String getTagName() {
        return tagName;
    }

    public SimpleLocation(final int columnNumber, final int lineNumber, final String tagName, final Attributes attributes) {
        this.columnNumber = columnNumber;
        this.lineNumber = lineNumber;
        this.tagName = tagName;
        this.attributes = attributes;
    }

    public SimpleLocation(final int columnNumber, final int lineNumber, final String tagName) {
        this(columnNumber, lineNumber, tagName, null);
    }

}
