/*
 * Created on Nov 13, 2005
 * 
 * $Id: SubmissionValidator.java,v 1.13 2006/05/16 10:37:38 dec Exp $
 */
package subproc;

import java.io.Reader;
import java.io.Writer;

import subproc.params.PAYEValidationParams;
import subproc.result.PAYEValidationResult;

import com.gsl.docValidator.ValidationException;

/**
 * This is the interface which defines the Submssion Validator component which
 * will be used by ERSS to validate incoming submissions.
 * 
 * @author douglas
 * @since Nov 13, 2005
 */
public interface SubmissionValidator {

    PAYEValidationResult validateSubmission(Reader input, Writer output, PAYEValidationParams params) throws ValidationException;

    /**
     * Causes the validator to terminate in an orderly fashion at the earliest
     * opportunity.
     */
    void interrupt();

    String getBusinessRulesVersion();
}
