package subproc;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import paye.eoy.validator.PAYEValidator;
import subproc.params.PAYEValidationParams;
import subproc.result.PAYEValidationResult;

import com.gsl.docValidator.ValidationException;
import com.gsl.logging.LoggerFactory;

public class SubmissionValidatorImpl implements SubmissionValidator {

    private PAYEValidator validator;

    public void interrupt() {
        final PAYEValidator validator = this.validator;
        if (validator != null) {
            validator.interrupt();
        }
    }

    public PAYEValidationResult validateSubmission(final Reader input, final Writer output, final PAYEValidationParams params)
            throws ValidationException {

        try {
            LoggerFactory.setScope("subproc");
            LoggerFactory.setLevels(params.getLoggingParams().getLogLevels());

            validator = new PAYEValidator();

            final paye.eoy.validator.PAYEValidationResult _result = validator.validateSubmission(input, output, params);

            return (PAYEValidationResult) Proxy.newProxyInstance(SubmissionValidatorImpl.class.getClassLoader(),
                    new Class[] { PAYEValidationResult.class }, new InvocationHandler() {
                        public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
                            return ((method.getDeclaringClass() == Object.class) ? Object.class
                                    : paye.eoy.validator.PAYEValidationResult.class).getMethod(method.getName(),
                                    method.getParameterTypes()).invoke(_result, args);
                        }
                    });
        } finally {
            validator = null;
        }
    }

    public String getBusinessRulesVersion() {
        return loadProcessorVersion();
    }

    public static final String loadProcessorVersion() {
        return PAYEValidator.getBusinessRulesVersion();
    }
}
