package subproc.main;

import com.gsl.util.classlookup.PropertiesFileGenerator;

/**
 * This is a utility to regenerate the properties files that contain the lists
 * of classes for BusinessRules, ErrorMappers and GenericErrorMappers.
 * 
 * @author Doug Clinton
 * 
 */
public class GenerateClassPropertiesFiles {

    private static String[][] data = {
            { "paye.eoy.bizrules", "bizrules.BusinessRule",
                    "..../eoy/payeEOYRules/src/main/resources/paye/eoy/bizrules/CollectedBusinessRule.properties" },

            { "paye.eoy.output.mapper", "ericResponse.output.translator.mapper.ErrorMapper",
                    "..../eoy/payeEOYErrorMappers/src/main/resources/paye/eoy/output/mapper/CollectedErrorMapper.properties" },

            { "paye.eoy.output.mapper.generic", "ericResponse.output.translator.genericerror.GenericErrorMapper",
                    "../../eoy/payeEOYErrorMappers/src/main/resources/paye/eoy/output/mapper/generic/CollectedGenericErrorMapper.properties" } };

    public static void main(final String[] args) throws Exception {
        for (final String[] element : data) {
            final String className = element[1];
            final Class<?> typeToFind = Class.forName(className);
            final int count = PropertiesFileGenerator.writeClassesToPropertiesFile(element[0], typeToFind, element[2]);
            System.out.println("Wrote " + count + " classes to " + element[2]);
        }
    }
}
