package subproc.main;

/*
 * Created on Nov 23, 2005
 * 
 * $Id$
 */

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import paye.multiyear.TaxYear;
import subproc.SubmissionValidator;
import subproc.SubmissionValidatorFactory;
import subproc.params.PAYEValidationParams;

import com.gsl.docValidator.ValidationException;
import com.gsl.logging.LoggerFactory;

import ericResponse.output.error.ErrorXmlUtils;

/**
 * $Id$
 */
public class PerformanceTest {
    public static void main(final String args[]) throws IOException {

        final Logger LOGGER = LoggerFactory.getLogger("subproc");
        if (args.length < 2) {
            LOGGER.warning("Usage: PerformanceTest <file to parse> <tax_year>");
            System.exit(1);
        }

        try {
            final BufferedReader inputReader = new BufferedReader(new FileReader(args[0]));
            final char[] chars = new char[20480];
            final int charsRead = inputReader.read(chars, 0, chars.length);
            if (charsRead == chars.length) {
                LOGGER.warning("File is too big");
                System.exit(2);
            }
            final String s = new String(chars);
            final StringReader reader = new StringReader(s);

            final TaxYear taxYear;

            if (args.length >= 2) {
                taxYear = TaxYear.fromString(args[1]);
            } else {

                final Date periodEndDate = ErrorXmlUtils.getPeriodEnd(reader);

                if (periodEndDate == null) {
                    taxYear = TaxYear.TAX_YEAR_0405;
                } else {
                    taxYear = TaxYear.estimateFromPeriodEndDate(periodEndDate);
                }
            }

            final PAYEValidationParams params = new PAYEValidationParams();
            params.setTaxYear(taxYear);
            params.getResponseParams().setOutputExtraDetails(true);
            params.getResponseParams().setSortErrorsEnabled(true);
            params.getLoggingParams().setDefaultLevel(Level.WARNING);

            final StringWriter output = new StringWriter(8000);
            final long startTime = System.currentTimeMillis();
            final int iterationCount = 5000;
            LOGGER.info("Running " + iterationCount + " iterations");
            for (int i = 0; i < iterationCount; i++) {
                final SubmissionValidator submissionValidator = SubmissionValidatorFactory.getInstance();
                submissionValidator.validateSubmission(reader, output, params);
            }
            final long endTime = System.currentTimeMillis();

            final long elapsedTime = endTime - startTime;
            LOGGER.info("Execution time: " + elapsedTime + "ms");
            System.err.println("Time for " + iterationCount + " iterations was " + elapsedTime + "ms");
            System.err.println("Time per submission was " + elapsedTime / iterationCount + "ms");
            System.err.println("Submissions per second is " + (iterationCount / (elapsedTime / 1000)));
        } catch (final ValidationException e) {
            e.printStackTrace();

        } catch (final FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

}
