package subproc.main;

/*
 * Created on Nov 23, 2005
 * 
 * $Id: RecursiveDirectorySubprocRunner.java,v 1.1 2006/03/07 10:40:51 gfry Exp $
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import paye.multiyear.TaxYear;
import subproc.SubmissionValidator;
import subproc.SubmissionValidatorFactory;
import subproc.SubmissionValidatorImpl;
import subproc.params.PAYEValidationParams;
import subproc.result.PAYEValidationResult;

import com.gsl.docValidator.ValidationException;
import com.gsl.io.core.file.RecursiveFileProvider;
import com.gsl.logging.LoggerFactory;

import ericResponse.output.error.ErrorXmlUtils;

/**
 * $Id: RecursiveDirectorySubprocRunner.java,v 1.1 2006/03/07 10:40:51 gfry Exp $
 */
public class RecursiveDirectorySubprocRunner {
    public static void main(final String args[]) {

        final Logger LOGGER = LoggerFactory.getLogger("subproc");

        if (args.length == 0) {
            LOGGER.warning("Usage: RecursiveDirectorySubprocRunner <directory to parse> <{|TPVS}>");
            System.exit(1);
        }

        final RecursiveFileProvider recursiveFileProvider = new RecursiveFileProvider(args[0]);

        final long startTime = System.currentTimeMillis();

        for (int i = 0; i < recursiveFileProvider.getFileCount(); i++) {
            final File f = recursiveFileProvider.getNextFile();
            processSingleFile(f, LOGGER);
        }

        LOGGER.info("Processing complete.  Processed " + recursiveFileProvider.getFileCount() + " submissions in "
                + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void processSingleFile(final File f, final Logger LOGGER) {

        LOGGER.info("Processing file:" + f.getAbsolutePath());

        try {
            final Reader reader = new BufferedReader(new FileReader(f));

            final TaxYear taxYear;

            final Date periodEndDate = ErrorXmlUtils.getPeriodEnd(reader);

            if (periodEndDate == null) {
                // Default to 0405 if unable to locate a periodEnd
                taxYear = TaxYear.TAX_YEAR_0405;
            } else {
                taxYear = TaxYear.estimateFromPeriodEndDate(periodEndDate);
            }

            LOGGER.warning("TaxYear :" + taxYear);

            final PAYEValidationParams params = new PAYEValidationParams();
            params.setTaxYear(taxYear);
            params.getResponseParams().setOutputExtraDetails(true);
            params.getResponseParams().setSortErrorsEnabled(true);
            params.setToleranceCheckRequired(false);
            params.getLoggingParams().setDefaultLevel(Level.INFO);

            final SubmissionValidator submissionValidator = SubmissionValidatorFactory.getInstance();
            final PAYEValidationResult result = submissionValidator.validateSubmission(reader, new OutputStreamWriter(System.out),
                    params);

            LOGGER.info(result.toString());
            LOGGER.info(SubmissionValidatorImpl.loadProcessorVersion());

        } catch (final ValidationException e) {
            e.printStackTrace();

        } catch (final FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }
}
